/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.startup;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.servlet.helptools.HelpSupport;
import com.ibm.hwmca.fw.shutdown.ShutdownDialog;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.IniFileProcessor;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BobcatStartupServlet
extends HttpServlet {
    private static final String TRACE_MASKT = "XFRMUNIT";
    private static final String TRACE_MASKF = "XFRMUNIF";
    private static final String START_INI_FILE_NAME = "clientstart.ini";

    public void init() throws ServletException {
        Trace.trace(TRACE_MASKT, "-> BobcatStartupServlet.init");
        try {
            Class.forName("com.ibm.hwmca.fw.system.Manager");
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "Exception loading Manager class");
            Trace.trace(TRACE_MASKT, e);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "Loaded the class.. setting location");
        CommonSystem.getCommonSystem().setLocation(3);
        Trace.trace(TRACE_MASKF, "set location.. starting manager");
        Manager.main(new String[0]);
        Trace.trace(TRACE_MASKF, "back from Manager.main");
        Manager manager = Manager.getManager();
        Trace.trace(TRACE_MASKF, "got manager.. waiting until safe");
        manager.waitUntilSafeForClient();
        Trace.trace(TRACE_MASKF, "safe!!!");
        if (!manager.managerStartupSucceeded()) {
            Trace.trace(TRACE_MASKT, "Exiting due to unsuccessful Manager startup");
            System.exit(102);
        }
        try {
            StartupThread starter = new StartupThread();
            HThreadGroup.defaultThreadGroup().createThread(starter, "BobcatMain").start();
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, t);
        }
        Trace.trace(TRACE_MASKT, "The unified startup main thread is ending");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "<> BobcatStartupServlet.doGet");
    }

    class BrowserRespawnThread
    extends Thread {
        Process browserProcess;
        boolean stopped = false;
        boolean browserRunning = true;

        BrowserRespawnThread() {
            super("Local browser process spawner");
        }

        public void run() {
            String geom;
            Dimension screen;
            String mozillaCmd;
            File operaFile;
            block21: {
                Trace.trace(BobcatStartupServlet.TRACE_MASKT, "-> BrowserRespawnThread.run");
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: starting browser for the first time.. pointing at preLogon servlet");
                this.removeLockFile();
                String operaFilename = System.getProperty("CONSOLE_PATH") + "use_opera";
                operaFile = new File(operaFilename);
                mozillaCmd = System.getProperty("DEVELOPMENT_SYSTEM", "no").equalsIgnoreCase("yes") ? (operaFile.exists() ? "opera -nosession -newwindow -windowname main" : "mozilla") : (operaFile.exists() ? "opera -nomenu -nocontextmenu -nosplash -nosession -newwindow -windowname main" : "mozilla -P default");
                int num = 0;
                while (num < 10) {
                    try {
                        Socket socket = new Socket("127.0.0.1", 8080);
                        socket.close();
                        break;
                    }
                    catch (IOException e) {
                        Trace.trace(BobcatStartupServlet.TRACE_MASKF, "Server not up yet.. sleeping");
                        ++num;
                        try {
                            Thread.currentThread();
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                try {
                    if (operaFile.exists()) {
                        screen = Toolkit.getDefaultToolkit().getScreenSize();
                        geom = " -geometry 750x600+" + (screen.width - 750) / 2 + "+" + (screen.height - 600) / 2;
                        this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + geom);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        Runtime.getRuntime().exec("opera -nosession -windowname main -remote openURL(http://127.0.0.1:8080/prelogon.html)");
                        break block21;
                    }
                    this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + " http://127.0.0.1:8080/prelogon.html");
                }
                catch (IOException e) {
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: failed to start browser.");
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
                    return;
                }
            }
            while (true) {
                this.browserRunning = true;
                while (this.browserRunning) {
                    try {
                        this.browserProcess.waitFor();
                        Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: browser returned.");
                        this.browserRunning = false;
                    }
                    catch (InterruptedException e) {}
                }
                if (this.stopped) break;
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: respawning browser.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.removeLockFile();
                try {
                    if (operaFile.exists()) {
                        screen = Toolkit.getDefaultToolkit().getScreenSize();
                        geom = " -geometry 750x600+" + (screen.width - 750) / 2 + "+" + (screen.height - 600) / 2;
                        this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + geom);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        Runtime.getRuntime().exec("opera -nosession -windowname main -remote openURL(http://127.0.0.1:8080/localindex.html)");
                        continue;
                    }
                    this.browserProcess = Runtime.getRuntime().exec(mozillaCmd + " http://127.0.0.1:8080/localindex.html");
                }
                catch (IOException e) {
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread: failed to start browser");
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
                    return;
                }
            }
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "<- BrowserRespawnThread.run");
        }

        private void removeLockFile() {
            Trace.trace(BobcatStartupServlet.TRACE_MASKT, "-> BrowserRespawnThread.removeLockFile()");
            try {
                String script = BaseFileControl.getFilePath("runAsRoot") + "removeMozillaLockFile.sh";
                Process p = Runtime.getRuntime().exec(script);
                int rc = 0;
                boolean done = false;
                while (!done) {
                    try {
                        rc = p.waitFor();
                        done = true;
                    }
                    catch (InterruptedException e) {}
                }
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespawnThread.removeLockFile: script returned " + rc);
            }
            catch (HException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
            catch (IOException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
            Trace.trace(BobcatStartupServlet.TRACE_MASKT, "<- BrowserRespawnThread.removeLockFile()");
        }

        void stopBrowser() {
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "<> BrowserRespawnThread.stopBrowser()");
            this.stopped = true;
            this.browserProcess.destroy();
            try {
                Runtime.getRuntime().exec("killall -15 mozilla-bin");
            }
            catch (IOException e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "BrowserRespansThread.stopBrowser: failed to kill mozilla-bin");
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
        }
    }

    class StartupThread
    extends Thread {
        public StartupThread() {
            super("BobcatStartupServlet.StartupThread");
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "StartupThread.ctor()");
        }

        public void run() {
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "-> StartupThread.run()");
            try {
                HelpSupport.prepareHelpWebapp();
                ClientUserContext cuc = new ClientUserContext(new ConnectionFactory(CommonSystem.getCommonSystem().getManagerHost(), 9940));
                cuc.attachToThread(true);
                IniFileProcessor.runClasses(BobcatStartupServlet.START_INI_FILE_NAME, "Client INI");
                try {
                    ShutdownDialog.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                BrowserRespawnThread browserThread = null;
                boolean startBrowser = System.getProperty("START_BROWSER", "true").equals("true");
                if (startBrowser) {
                    browserThread = new BrowserRespawnThread();
                    browserThread.start();
                }
                Client startupClient = new Client("com.ibm.hwmca.fw.system.KeepAliveTasklet", null);
                TaskletResponse response = startupClient.init();
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "Startup.run: Tasklet responded.. shutting down");
                if (browserThread != null) {
                    Trace.trace(BobcatStartupServlet.TRACE_MASKF, "Startup.run: killing browser");
                    browserThread.stopBrowser();
                }
                Integer rc = (Integer)response.getData("RC");
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "Startup.run: Exiting with value " + rc);
                String desktopFileName = BaseFileControl.getFilePath("actzdesk.dat") + "actzdesk.dat";
                File desktopFile = new File(desktopFileName);
                if (desktopFile.exists()) {
                    LocalizableText text = null;
                    switch (rc) {
                        case 100: {
                            text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.restart");
                            break;
                        }
                        case 102: {
                            text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.shutdown");
                            break;
                        }
                        case 103: {
                            text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.poweroff");
                            break;
                        }
                        default: {
                            text = new LocalizableText(CommonResourceBundle.getBundleName(), "shutdown.reboot");
                        }
                    }
                    String[] cmd = text != null ? new String[5] : new String[]{"java", "-classpath", System.getProperty("java.class.path"), "com.ibm.hwmca.fw.shutdown.ShutdownDialog"};
                    if (text != null) {
                        cmd[4] = text.toString();
                    }
                    Runtime.getRuntime().exec(cmd);
                    try {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "writing rc file");
                File rcFile = new File(System.getProperty("CONSOLE_PATH") + "rc");
                FileWriter rcOut = new FileWriter(rcFile);
                rcOut.write(rc.toString());
                rcOut.flush();
                rcOut.close();
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "reading bobcat pid");
                String bobcatPidFile = System.getProperty("CONSOLE_PATH") + "bobcat/profiles/hmcprofile/logs/hmcserver/hmcserver.pid";
                BufferedReader pidIn = new BufferedReader(new FileReader(bobcatPidFile));
                String bobcatPid = pidIn.readLine();
                pidIn.close();
                String killCmd = "kill -9 " + bobcatPid;
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "About to kill bobcat with cmd: " + killCmd);
                Runtime.getRuntime().exec(killCmd);
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, "back from killing bobcat");
            }
            catch (Exception e) {
                Trace.trace(BobcatStartupServlet.TRACE_MASKF, e);
            }
            Trace.trace(BobcatStartupServlet.TRACE_MASKF, "<- StartupThread.run()");
        }
    }
}

